/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.FileTransfer;
import org.glassfish.grizzly.GracefulShutdownListener;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.Reader;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.StandaloneProcessorSelector;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.Writer;
import org.glassfish.grizzly.asyncqueue.AsyncQueueIO;
import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.asyncqueue.WritableMessage;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainEnabledTransport;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.monitoring.MonitoringUtils;
import org.glassfish.grizzly.nio.DirectByteBufferRecord;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorIO;
import org.glassfish.grizzly.nio.transport.UDPNIOAsyncQueueReader;
import org.glassfish.grizzly.nio.transport.UDPNIOAsyncQueueWriter;
import org.glassfish.grizzly.nio.transport.UDPNIOBindingHandler;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.UDPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTemporarySelectorReader;
import org.glassfish.grizzly.nio.transport.UDPNIOTemporarySelectorWriter;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportFilter;
import org.glassfish.grizzly.utils.Futures;

public final class UDPNIOTransport
extends NIOTransport
implements FilterChainEnabledTransport {
    static final Logger LOGGER = Grizzly.logger(UDPNIOTransport.class);
    private static final String DEFAULT_TRANSPORT_NAME = "UDPNIOTransport";
    protected final Collection<UDPNIOServerConnection> serverConnections;
    protected final AsyncQueueIO<SocketAddress> asyncQueueIO;
    private final Filter transportFilter;
    protected final RegisterChannelCompletionHandler registerChannelCompletionHandler;
    private final UDPNIOConnectorHandler connectorHandler = new TransportConnectorHandler();
    private final UDPNIOBindingHandler bindingHandler = new UDPNIOBindingHandler(this);

    public UDPNIOTransport() {
        this(DEFAULT_TRANSPORT_NAME);
    }

    public UDPNIOTransport(String name) {
        super(name != null ? name : DEFAULT_TRANSPORT_NAME);
        this.readBufferSize = -1;
        this.writeBufferSize = -1;
        this.registerChannelCompletionHandler = new RegisterChannelCompletionHandler();
        this.asyncQueueIO = AsyncQueueIO.Factory.createImmutable(new UDPNIOAsyncQueueReader(this), new UDPNIOAsyncQueueWriter(this));
        this.transportFilter = new UDPNIOTransportFilter(this);
        this.serverConnections = new ConcurrentLinkedQueue<UDPNIOServerConnection>();
    }

    @Override
    protected TemporarySelectorIO createTemporarySelectorIO() {
        return new TemporarySelectorIO(new UDPNIOTemporarySelectorReader(this), new UDPNIOTemporarySelectorWriter(this));
    }

    @Override
    protected void listen() {
        for (UDPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                serverConnection.register();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_TRANSPORT_START_SERVER_CONNECTION_EXCEPTION(serverConnection), e);
            }
        }
    }

    @Override
    public synchronized boolean addShutdownListener(GracefulShutdownListener shutdownListener) {
        Transport.State state = this.getState().getState();
        if (state != Transport.State.STOPPING || state != Transport.State.STOPPED) {
            if (this.shutdownListeners == null) {
                this.shutdownListeners = new HashSet();
            }
            return this.shutdownListeners.add(shutdownListener);
        }
        return false;
    }

    @Override
    public UDPNIOServerConnection bind(int port) throws IOException {
        return this.bind(new InetSocketAddress(port));
    }

    @Override
    public UDPNIOServerConnection bind(String host, int port) throws IOException {
        return this.bind(host, port, 50);
    }

    @Override
    public UDPNIOServerConnection bind(String host, int port, int backlog) throws IOException {
        return this.bind(new InetSocketAddress(host, port), backlog);
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, 4096);
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        return this.bindingHandler.bind(socketAddress, backlog);
    }

    @Override
    public Connection bindToInherited() throws IOException {
        return this.bindingHandler.bindToInherited();
    }

    @Override
    public UDPNIOServerConnection bind(String host, PortRange portRange, int backlog) throws IOException {
        return (UDPNIOServerConnection)this.bindingHandler.bind(host, portRange, backlog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Connection connection) {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            if (connection != null && this.serverConnections.remove(connection)) {
                FutureImpl future = Futures.createSafeFuture();
                ((UDPNIOServerConnection)connection).unbind(Futures.toCompletionHandler(future));
                try {
                    future.get(1000L, TimeUnit.MILLISECONDS);
                    future.recycle(false);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_TRANSPORT_UNBINDING_CONNECTION_EXCEPTION(connection), e);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() {
        ReentrantReadWriteLock.WriteLock lock = this.state.getStateLocker().writeLock();
        lock.lock();
        try {
            for (Connection connection : this.serverConnections) {
                try {
                    this.unbind(connection);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "Exception occurred when closing server connection: " + connection, e);
                }
            }
            this.serverConnections.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public GrizzlyFuture<Connection> connect() throws IOException {
        return this.connectorHandler.connect();
    }

    public GrizzlyFuture<Connection> connect(String host, int port) throws IOException {
        return this.connectorHandler.connect(host, port);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress) {
        return this.connectorHandler.connect(remoteAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, CompletionHandler<Connection> completionHandler) {
        this.connectorHandler.connect(remoteAddress, completionHandler);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connectorHandler.connect(remoteAddress, localAddress);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) {
        this.connectorHandler.connect(remoteAddress, localAddress, completionHandler);
    }

    @Override
    protected void closeConnection(Connection connection) throws IOException {
        SelectableChannel nioChannel = ((NIOConnection)connection).getChannel();
        if (nioChannel != null) {
            try {
                nioChannel.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "UDPNIOTransport.closeChannel exception", e);
            }
        }
        if (this.asyncQueueIO != null) {
            AsyncQueueWriter<SocketAddress> writer;
            AsyncQueueReader<SocketAddress> reader = this.asyncQueueIO.getReader();
            if (reader != null) {
                reader.onClose(connection);
            }
            if ((writer = this.asyncQueueIO.getWriter()) != null) {
                writer.onClose(connection);
            }
        }
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = null;
                this.processorSelector = null;
            }
        }
    }

    @Override
    public Filter getTransportFilter() {
        return this.transportFilter;
    }

    @Override
    public AsyncQueueIO getAsyncQueueIO() {
        return this.asyncQueueIO;
    }

    @Override
    public TemporarySelectorIO getTemporarySelectorIO() {
        return this.temporarySelectorIO;
    }

    @Override
    public void fireIOEvent(IOEvent ioEvent, Connection connection, IOEventLifeCycleListener listener) {
        Processor conProcessor = connection.obtainProcessor(ioEvent);
        ProcessorExecutor.execute(Context.create(connection, conProcessor, ioEvent, listener));
    }

    @Override
    public Reader getReader(Connection connection) {
        return this.getReader(connection.isBlocking());
    }

    @Override
    public Reader getReader(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getReader();
        }
        return this.getAsyncQueueIO().getReader();
    }

    @Override
    public Writer getWriter(Connection connection) {
        return this.getWriter(connection.isBlocking());
    }

    @Override
    public Writer getWriter(boolean isBlocking) {
        if (isBlocking) {
            return this.getTemporarySelectorIO().getWriter();
        }
        return this.getAsyncQueueIO().getWriter();
    }

    private int readConnected(UDPNIOConnection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        boolean hasRead;
        int read2;
        int oldPos = buffer.position();
        if (buffer.isComposite()) {
            ByteBufferArray array = buffer.toByteBufferArray();
            ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
            int size2 = array.size();
            read2 = (int)((DatagramChannel)connection.getChannel()).read(byteBuffers, 0, size2);
            array.restore();
            array.recycle();
        } else {
            read2 = ((DatagramChannel)connection.getChannel()).read(buffer.toByteBuffer());
        }
        boolean bl = hasRead = read2 > 0;
        if (hasRead) {
            buffer.position(oldPos + read2);
        }
        if (hasRead && currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setReadSize(currentResult.getReadSize() + read2);
            currentResult.setSrcAddressHolder(connection.peerSocketAddressHolder);
        }
        return read2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readNonConnected(UDPNIOConnection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        boolean hasRead;
        int read2;
        SocketAddress peerAddress;
        DirectByteBufferRecord ioRecord = DirectByteBufferRecord.get();
        try {
            ByteBuffer directByteBuffer = ioRecord.allocate(buffer.limit());
            int initialBufferPos = directByteBuffer.position();
            peerAddress = ((DatagramChannel)connection.getChannel()).receive(directByteBuffer);
            read2 = directByteBuffer.position() - initialBufferPos;
            if (read2 > 0) {
                directByteBuffer.flip();
                buffer.put(directByteBuffer);
            }
        }
        finally {
            ioRecord.release();
        }
        boolean bl = hasRead = read2 > 0;
        if (hasRead && currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setReadSize(currentResult.getReadSize() + read2);
            currentResult.setSrcAddress(peerAddress);
        }
        return read2;
    }

    public int read(UDPNIOConnection connection, Buffer buffer) throws IOException {
        return this.read(connection, buffer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(UDPNIOConnection connection, Buffer buffer, ReadResult<Buffer, SocketAddress> currentResult) throws IOException {
        boolean isAllocate;
        int read2 = 0;
        boolean bl = isAllocate = buffer == null && currentResult != null;
        if (isAllocate) {
            buffer = this.memoryManager.allocateAtLeast(connection.getReadBufferSize());
        }
        try {
            read2 = connection.isConnected() ? this.readConnected(connection, buffer, currentResult) : this.readNonConnected(connection, buffer, currentResult);
            connection.onRead(buffer, read2);
        }
        catch (Exception e) {
            read2 = -1;
        }
        finally {
            if (isAllocate) {
                if (read2 <= 0) {
                    buffer.dispose();
                } else {
                    buffer.allowBufferDispose(true);
                }
            }
        }
        return read2;
    }

    public long write(UDPNIOConnection connection, SocketAddress dstAddress, WritableMessage message) throws IOException {
        return this.write(connection, dstAddress, message, null);
    }

    public long write(UDPNIOConnection connection, SocketAddress dstAddress, WritableMessage message, WriteResult<WritableMessage, SocketAddress> currentResult) throws IOException {
        long written;
        if (message instanceof Buffer) {
            Buffer buffer = (Buffer)message;
            int oldPos = buffer.position();
            if (dstAddress != null) {
                written = ((DatagramChannel)connection.getChannel()).send(buffer.toByteBuffer(), dstAddress);
            } else if (buffer.isComposite()) {
                ByteBufferArray array = buffer.toByteBufferArray();
                ByteBuffer[] byteBuffers = (ByteBuffer[])array.getArray();
                int size2 = array.size();
                written = ((DatagramChannel)connection.getChannel()).write(byteBuffers, 0, size2);
                array.restore();
                array.recycle();
            } else {
                written = ((DatagramChannel)connection.getChannel()).write(buffer.toByteBuffer());
            }
            if (written > 0L) {
                buffer.position(oldPos + (int)written);
            }
            connection.onWrite(buffer, (int)written);
        } else if (message instanceof FileTransfer) {
            written = ((FileTransfer)message).writeTo((DatagramChannel)connection.getChannel());
        } else {
            throw new IllegalStateException("Unhandled message type");
        }
        if (currentResult != null) {
            currentResult.setMessage(message);
            currentResult.setWrittenSize(currentResult.getWrittenSize() + written);
            currentResult.setDstAddressHolder(connection.peerSocketAddressHolder);
        }
        return written;
    }

    UDPNIOConnection obtainNIOConnection(DatagramChannel channel) {
        UDPNIOConnection connection = new UDPNIOConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    UDPNIOServerConnection obtainServerNIOConnection(DatagramChannel channel) {
        UDPNIOServerConnection connection = new UDPNIOServerConnection(this, channel);
        this.configureNIOConnection(connection);
        return connection;
    }

    @Override
    protected Object createJmxManagementObject() {
        return MonitoringUtils.loadJmxObject("org.glassfish.grizzly.nio.transport.jmx.UDPNIOTransport", this, UDPNIOTransport.class);
    }

    protected class TransportConnectorHandler
    extends UDPNIOConnectorHandler {
        public TransportConnectorHandler() {
            super(UDPNIOTransport.this);
        }

        @Override
        public Processor getProcessor() {
            return UDPNIOTransport.this.getProcessor();
        }

        @Override
        public ProcessorSelector getProcessorSelector() {
            return UDPNIOTransport.this.getProcessorSelector();
        }
    }

    protected class RegisterChannelCompletionHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        protected RegisterChannelCompletionHandler() {
        }

        @Override
        public void completed(RegisterChannelResult result2) {
            SelectionKey selectionKey = result2.getSelectionKey();
            UDPNIOConnection connection = (UDPNIOConnection)UDPNIOTransport.this.getSelectionKeyHandler().getConnectionForKey(selectionKey);
            if (connection != null) {
                SelectorRunner selectorRunner = result2.getSelectorRunner();
                connection.setSelectionKey(selectionKey);
                connection.setSelectorRunner(selectorRunner);
            }
        }
    }
}

